{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:38:49 $                                        =}
{========================================================================}
unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Menus, Buttons, MMSystem, MMObj, 
  MPlayer, MMCDInfo, MMLEDs, MMDIBCv, MMLevel, MMWavIn, MMAbout, MMConect,
  MMDesign, MMDSPObj, MMHook;

const
  NoDisc1 = 'Data or no disc loaded.';
  NoDisc2 = 'Please insert an audio compact disc.';
  StepWidth = 5;

type
  TTimeMode = (tmTrackElapsed,tmTrackRemaining,tmDiscRemaining);
  TTrackRec = record
       Track : Byte;
       Length: Longint;
  end;
  PPlayList = ^TPlayList;
  TPlayList = array[0..0] of TTrackRec;

  TMainForm = class(TForm)
    MMCDInfo1: TMMCDInfo;
    MainMenu1: TMainMenu;
    Disc1: TMenuItem;
    View1: TMenuItem;
    Options1: TMenuItem;
    AboutMenu: TMenuItem;
    Bevel1: TBevel;
    ToolBar1: TPanel;
    PlayListButton: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    PlayListMenu: TMenuItem;
    N1: TMenuItem;
    ExitMenu: TMenuItem;
    ToolBarMenu: TMenuItem;
    DiscInfoMenu: TMenuItem;
    N2: TMenuItem;
    TimeMenu1: TMenuItem;
    TimeMenu2: TMenuItem;
    TimeMenu3: TMenuItem;
    RandomMenu: TMenuItem;
    ContinuousMenu: TMenuItem;
    IntroMenu: TMenuItem;
    N3: TMenuItem;
    PreferencesMenu: TMenuItem;
    MMWaveIn1: TMMWaveIn;
    Panel1: TPanel;
    MediaPlayer1: TMediaPlayer;
    Display1: TPanel;
    MMLEDDigit1: TMMLEDDigit;
    tt2: TMMLEDDigit;
    tt: TMMLEDDigit;
    mm2: TMMLEDDigit;
    ss: TMMLEDDigit;
    Colon1: TMMLEDDigit;
    Level2: TMMLevel;
    Level1: TMMLevel;
    Label11: TLabel;
    Label12: TLabel;
    mm: TMMLEDDigit;
    ss2: TMMLEDDigit;
    TotalMin: TMMLEDPanel;
    TotalSec: TMMLEDPanel;
    DiscInfo1: TPanel;
    Tracks1: TComboBox;
    Label1: TLabel;
    Artist1: TPanel;
    Title1: TPanel;
    MMConnector1: TMMConnector;
    MMDesigner1: TMMDesigner;
    procedure MMCDInfo1Timer(Sender: TObject);
    procedure MMCDInfo1Ready(Sender: TObject);
    procedure MMCDInfo1DoorOpen(Sender: TObject);
    procedure MMCDInfo1DoorClose(Sender: TObject);
    procedure Tracks1Change(Sender: TObject);
    procedure MediaPlayer1Notify(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MediaPlayer1Click(Sender: TObject; Button: TMPBtnType;
                                var DoDefault: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimeModeChanged(Sender: TObject);
    procedure Display1Click(Sender: TObject);
    procedure ContinuousChanged(Sender: TObject);
    procedure IntroChanged(Sender: TObject);
    procedure RandomChanged(Sender: TObject);
    procedure MMWaveIn1Stop(Sender: TObject);
    procedure ExitMenuClick(Sender: TObject);
    procedure ToolBarMenuClick(Sender: TObject);
    procedure DiscInfoMenuClick(Sender: TObject);
    procedure AboutMenuClick(Sender: TObject);
    procedure PreferencesMenuClick(Sender: TObject);
    procedure PlayListMenuClick(Sender: TObject);
  private
    procedure WMGetMinMaxInfo(Var Msg: TWMGetMinMaxInfo); message WM_GETMINMAXINFO;
    procedure WMInitMenuPopup(Var Msg: TWMInitMenuPopup); message WM_INITMENUPOPUP;
    procedure WMNCHitTest(Var Msg: TWMNCHitTest); message WM_NCHitTest;

  public
    SyncPlayList: Boolean;
    PlayList: PPlayList;
    Paused: Boolean;
    RandomPlay: Boolean;
    ContinuousPlay: Boolean;
    IntroPlay: Boolean;
    IntroLength: integer;
    TimeMode: TTimeMode;
    UpdateDisplay: Boolean;
    oTrack, oMin, oSec: Byte;
    StopOnExit: Boolean;
    MinMaxHeight: integer;

    procedure SetupPlayList;
    procedure PlayListChanged;
    function  FindTrackInPlayList(aTrack: Byte): integer;
    procedure ChangeTrack(PlayIt: Boolean);
    function  CalcTime: Longint;
    procedure DrawTime(PlayerPos: Longint);
    function  StartPosition(Track: Byte): Longint;
    function  EndPosition(Track: Byte): Longint;
    procedure EjectClose;
    procedure SetButtons;
  end;

var
  MainForm: TMainForm;

implementation

uses Settings, Preferc;

{$R *.DFM}
{$IFDEF WIN32}
   {$R CDPLAY32.RES}
{$ELSE}
   {$R CDPLAY.RES}
{$ENDIF}

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.WMGetMinMaxInfo(Var Msg: TWMGetMinMaxInfo);
begin
     if MinMaxHeight > 0 then
     begin
        with Msg.MinMaxInfo^ do
        begin
           ptMinTrackSize.X := Width;         { Minimum width  }
           ptMinTrackSize.Y := MinMaxHeight;  { Minimum height }
           ptMaxTrackSize.X := Width;         { Maximum width  }
           ptMaxTrackSize.Y := MinMaxHeight;  { Maximum height }
        end;
        Msg.Result := 0;       { Tell windows you have changed minmaxinfo }
     end;
     inherited;  
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.WMInitMenuPopup(Var Msg: TWMInitMenuPopup);
begin
   inherited;
   if Msg.SystemMenu then
      EnableMenuItem(Msg.MenuPopup, SC_SIZE, MF_BYCOMMAND or MF_GRAYED);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.WMNCHitTest(Var Msg: TWMNCHitTest);
begin
   inherited;
   with Msg do
     if Result in [HTLEFT, HTRIGHT, HTBOTTOM, HTBOTTOMRIGHT,
                   HTBOTTOMLEFT, HTTOP, HTTOPRIGHT, HTTOPLEFT] then
        Result:= HTNOWHERE;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.EjectClose;
Var
  SetParm: TMCI_Set_Parms;
  Flags: Longint;

begin
     if MediaPlayer1.DeviceID <> 0 then
     with MediaPlayer1 do
     begin
          FillChar(SetParm, sizeOf(SetParm),0);
          Flags := MCI_WAIT;
    
          if (Mode = mpOpen) then FLags := Flags or MCI_Set_Door_Closed
          else Flags := Flags or MCI_Set_Door_Open;

          mciSendCommand(DeviceID, MCI_SET, Flags, Longint(@SetParm));
     end; 
end; 

{-- TMainForm ------------------------------------------------------------}
function TMainForm.StartPosition(Track: Byte): Longint;
begin
     Result := MCI_MAKE_TMSF(Track,0,0,0);
end;

{-- TMainForm ------------------------------------------------------------}
function TMainForm.EndPosition(Track: Byte): Longint;
begin
     with MediaPlayer1 do
     if IntroPlay then
     begin
          if IntroLength < MSF2Second(TrackLength[Track]) then
             Result := MCI_MAKE_TMSF(Track,0,IntroLength+1,0)
          else Result := MCI_MAKE_TMSF(Track,
                                       MCI_MSF_Minute(TrackLength[Track]),
                                       MCI_MSF_Second(TrackLength[Track]),
                                       MCI_MSF_Frame(TrackLength[Track]));
     end
     else Result := MCI_MAKE_TMSF(Track,
                                  MCI_MSF_Minute(TrackLength[Track]),
                                  MCI_MSF_Second(TrackLength[Track]),
                                  MCI_MSF_Frame(TrackLength[Track]));
end;
                  
{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DrawTime(PlayerPos: Longint);
var
   aLength: Longint;
   aTrack,aMin,aSec: Byte;

begin
     aTrack := MCI_TMSF_Track(PlayerPos);
     if (aTrack <> oTrack) then 
     begin
          if aTrack > 0 then aLength := MediaPlayer1.TrackLength[aTrack]
          else aLength := 0;
          TotalSec.Value := MCI_MSF_Second(aLength);
          TotalMin.Value := MCI_MSF_Minute(aLength);
          tt.Value := aTrack;  
          oTrack := aTrack;
     end;

     aMin := MCI_TMSF_Minute(PlayerPos);
     if (aMin <> oMin) then 
     begin
          mm.Value := aMin;
          oMin := aMin;
     end;
     
     aSec := MCI_TMSF_Second(PlayerPos);
     if (aSec <> oSec) then 
     begin
          ss .Value := aSec;
          oSec := aSec;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
function TMainForm.CalcTime: Longint;
Var
   i: integer;
   aPos,aTrack,aLength,aTotal: Longint;

begin
     Result := 0;
     with MMCDInfo1, MediaPlayer1 do
     if NumPlay > 0 then
     case TimeMode of
        tmTrackElapsed  : Result := Position;
        tmTrackRemaining: begin
                             aPos := Position;
                             aTrack := MCI_TMSF_Track(aPos);
                             aLength := PlayList^[FindTrackInPlayList(aTrack)].Length;
                             aTotal := MSF2Second(aLength)-TMSF2Second(aPos);
                             Result := MCI_MAKE_TMSF(aTrack, aTotal div 60,
                                                     aTotal mod 60, 0);
                          end;
        tmDiscRemaining : begin
                             aPos := Position;
                             aTrack := MCI_TMSF_Track(aPos);
                             aTotal := 0;
                             for i := FindTrackInPlayList(aTrack) to NumPlay-1 do
                             begin
                                  aLength := PlayList^[i].Length;
                                  inc(aTotal,MSF2Second(aLength));
                             end;
                             dec(aTotal,TMSF2Second(aPos));
                             Result := MCI_MAKE_TMSF(aTrack, aTotal div 60,
                                                     aTotal mod 60, 0);
                          end;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMCDInfo1Timer(Sender: TObject);
begin
     Colon1.Enabled := Not Colon1.Enabled;
          
     if MediaPlayer1.DeviceID <> 0 then
     begin
        if UpdateDisplay then DrawTime(CalcTime);
     end
     else
     begin
          try
             MediaPlayer1.Open;
             SetButtons;
             Artist1.Caption := NoDisc1;
             Title1.Caption := NoDisc2;
             MMWaveIn1.Start;
          except
             on EMCIDeviceError do;
          end;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
function TMainForm.FindTrackInPlayList(aTrack: Byte): integer;
Var
   i: integer;

begin
     Result := -1;
     for i := 0 to MMCDInfo1.NumPlay-1 do
     if aTrack = PlayList^[i].Track then
     begin
          Result := i;
          exit;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.PlayListChanged;
begin
     with MMCDInfo1, MediaPlayer1 do
     begin
          Artist1.Caption := Artist;
          Title1.Caption := Title;
          if (PlayList <> Nil) then
          begin
             GlobalFreePtr(PlayList);
             PlayList := Nil;
          end;
          if (NumPlay > 0) then
          PlayList := GlobalAllocPtr(GHND, NumPlay * sizeOf(TTrackRec));
          SetupPlayList;
          SetButtons;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SetupPlayList;
Var
   i,j: integer;
   Ready: Boolean;
   aIndex: integer;
   aStr: String;

begin
     Tracks1.Clear;
     with MMCDInfo1, MediaPlayer1 do
     begin
        if Not RandomPlay then
        begin
           for i := 0 to NumPlay-1 do
           begin
              PlayList^[i].Track := PlayOrder[i]+1;
              PlayList^[i].Length := TrackLength[PlayList^[i].Track];
              if PlayList^[i].Track < 10 then aStr := '[0'+IntToStr(PlayList^[i].Track)+']'
              else aStr := '['+IntToStr(PlayList^[i].Track)+']';
              Tracks1.Items.Add(aStr+'  '+MMCDInfo1.Tracks.Strings[PlayList^[i].Track-1]);
           end;
        end
        else
        begin                   
           for i := 0 to NumPlay-1 do
           begin
              Repeat
                 Ready := True;
                 aIndex := PlayOrder[Random(NumPlay)]+1;
                 for j := 0 to i-1 do
                 begin
                     if PlayList^[j].Track <> PlayList^[i-1].Track then
                        if PlayList^[j].Track = aIndex then Ready := False;
                 end;
              until Ready;
              PlayList^[i].Track := aIndex;
              PlayList^[i].Length := TrackLength[PlayList^[i].Track];
              if PlayList^[i].Track < 10 then aStr := '[0'+IntToStr(PlayList^[i].Track)+']'
              else aStr := '['+IntToStr(PlayList^[i].Track)+']';
              Tracks1.Items.Add(aStr+'  '+MMCDInfo1.Tracks.Strings[PlayList^[i].Track-1]);
           end;
        end;

        aIndex := FindTrackInPlayList(MCI_TMSF_Track(Position)); 

        if (Mode = mpPlaying) then 
        begin
           if aIndex > -1 then
           begin
              Tracks1.ItemIndex := aIndex;
              if SyncPlayList then
              begin
                   EndPos := EndPosition(PlayList^[Tracks1.ItemIndex].Track);
                   StartPos := Position + MCI_MAKE_TMSF(0,0,0,20);
                   Play;
              end;
           end
           else
           begin
                if (NumPlay = 0) then
                begin
                     Stop;
                     Position := MCI_MAKE_TMSF(1,0,0,0);
                end;

                Tracks1.ItemIndex := 0;

                if (NumPlay > 0) then
                   ChangeTrack(True);
           end;
        end
        else
        begin
             if (aIndex = -1) Or SyncPlayList then
             begin
                  if (NumPlay = 0) then Position := MCI_MAKE_TMSF(1,0,0,0);
                  aIndex := 0;
             end;

             if (NumPlay > 0) then 
             begin
                  Tracks1.ItemIndex := aIndex;
                  ChangeTrack(False);
             end;
        end;
        SyncPlayList := False;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMCDInfo1Ready(Sender: TObject);
begin
     with MMCDInfo1, MediaPlayer1 do
     begin
          UpdateDisplay := True;
          PlayListChanged;
          PlayListButton.Enabled := True;
          PlayListMenu.Enabled := True;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMCDInfo1DoorOpen(Sender: TObject);
begin
     DrawTime(0);
     UpdateDisplay := False;
     SetButtons;
     Label1.Font.Color := clAqua;
     Artist1.Caption := NoDisc1;
     Title1.Caption := NoDisc2;
     Tracks1.Clear;
     PlayListButton.Enabled := False;
     PlayListMenu.Enabled := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMCDInfo1DoorClose(Sender: TObject);
begin
     Label1.Font.Color := clTeal;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SetButtons;
Var
   Buttons: TButtonSet;

begin
     with MMCDInfo1, MediaPlayer1 do
     begin
        Buttons := [];
        if (DeviceId <> 0) then
        begin
           Buttons := [btEject];
           if (NumPlay <> 0) then
           begin
              case Mode of
               mpPlaying: begin
                             Buttons := Buttons - [btPlay] + [btPause,btStop];
                             Buttons := Buttons + [btStep,btBack,btNext,btPrev];
                          end;
               mpStopped: begin
                             Buttons := Buttons + [btPlay] - [btPause,btStop];
                             Buttons := Buttons + [btStep,btBack,btNext,btPrev];
                          end;
               mpOpen   : Buttons := [btEject];
               else Buttons := [];
              end;
           end;
        end;
        EnabledButtons := Buttons;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ChangeTrack(PlayIt: Boolean);
begin
   with MMCDInfo1, MediaPlayer1  do
   begin
        StartPos := StartPosition(PlayList^[Tracks1.ItemIndex].Track);
        if (PlayIt AND (MCI_TMSF_Track(StartPos) < Tracks)) Or IntroPlay then
           EndPos := EndPosition(MCI_TMSF_Track(StartPos));

        if (PlayIt) then Play
        else Position := StartPos;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.Tracks1Change(Sender: TObject);
begin         
     with MMCDInfo1, MediaPlayer1 do
     begin
          if MCI_TMSF_Track(Position) <> PlayList^[Tracks1.ItemIndex].Track then
             ChangeTrack(Mode = mpPlaying);
     end; 
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MediaPlayer1Notify(Sender: TObject);
begin
    with MMCDInfo1, MediaPlayer1 do
    begin
        if MediaPlayer1.NotifyValue = nvSuccessful then 
        begin
            UpdateDisplay := False;
            if Tracks1.ItemIndex < NumPlay-1 then
            begin
                 Tracks1.ItemIndex := Tracks1.ItemIndex + 1;
                 ChangeTrack(True);
            end
            else 
            begin
                 Tracks1.ItemIndex := 0;
                 if ContinuousPlay then ChangeTrack(True)
                 else
                 begin
                      Open;
                      ChangeTrack(False);
                 end;
                 SetButtons;
            end;
            UpdateDisplay := True;
        end; 
    end;    
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
     MinMaxHeight := Height;
     Randomize;
     PlayListButton.Glyph.Handle := LoadBitmap(HInstance, 'CD_PLAYLIST');
     SpeedButton2.Glyph.Handle := LoadBitmap(HInstance, 'CD_TRACK_TIME_ELAPSED');
     SpeedButton3.Glyph.Handle := LoadBitmap(HInstance, 'CD_TRACK_TIME_REMAINING');
     SpeedButton4.Glyph.Handle := LoadBitmap(HInstance, 'CD_DISC_TIME_REMAINING');
     SpeedButton5.Glyph.Handle := LoadBitmap(HInstance, 'CD_RANDOM');
     SpeedButton6.Glyph.Handle := LoadBitmap(HInstance, 'CD_CONTINUOUS');
     SpeedButton7.Glyph.Handle := LoadBitmap(HInstance, 'CD_INTRO_SCAN');
     PlayList := Nil;
     SyncPlayList := True;
     UpdateDisplay := False;
     TimeMode := tmTrackElapsed;
     IntroLength := 10;
     RandomPlay:= False;
     ContinuousPlay := False;
     IntroPlay := False;
     Paused := False;
     StopOnExit := False;

     try
        MediaPlayer1.Open;
        Artist1.Caption := NoDisc1;
        Title1.Caption := NoDisc2;
        MMWaveIn1.Start;
     except
         on EMCIDeviceError do SetButtons;
     end;

     SetButtons;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     MMWaveIn1.Close;
     if StopOnExit then MediaPlayer1.Stop;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ExitMenuClick(Sender: TObject);
begin
     Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MediaPlayer1Click(Sender: TObject; Button: TMPBtnType;
                                      var DoDefault: Boolean);
Var
   aTrack: Byte;
   aPos,aTime: Longint;

begin
   DoDefault := False;
   with MMCDInfo1, MediaPlayer1 do
   begin
      case Button of
         btPlay : begin
                     if (MCI_TMSF_Track(Position) < Tracks) Or IntroPlay then
                        EndPos := EndPosition(MCI_TMSF_Track(Position));

                     if Paused then
                     begin
                          if (Mode = mpPaused) then Resume
                          else if (Mode = mpStopped) then Play;
                          Paused := False;
                     end
                     else
                     begin
                          if IntroPlay then
                             StartPos := StartPosition(MCI_TMSF_Track(Position));
                          Play;
                     end;
                     SetButtons;
                  end;
         btPause: begin
                     if (Mode = mpPlaying) then
                     begin
                        Pause;
                        Paused := True;
                        EnabledButtons := EnabledButtons + [btPlay];
                     end
                     else
                     begin
                          if (MCI_TMSF_Track(Position) < Tracks) Or IntroPlay then
                             EndPos := EndPosition(MCI_TMSF_Track(Position));
                          if (Mode = mpPaused) then Resume
                          else if (Mode = mpStopped) then Play;
                          Paused := False;
                          SetButtons;
                     end;
                  end;
         btStop : begin
                     Stop;
                     Tracks1.ItemIndex := 0;
                     ChangeTrack(False);
                     SetButtons;
                  end;
         btNext : begin
                     if Tracks1.ItemIndex < NumPlay-1 then
                        Tracks1.ItemIndex := Tracks1.ItemIndex + 1
                     else
                     begin
                        Tracks1.ItemIndex := 0;
                        if Not ContinuousPlay then MediaPlayer1.Stop;
                        SetButtons;
                     end;
                     ChangeTrack(Mode = mpPlaying);
                  end;
         btPrev : begin
                     aPos := Position;
    	             if (Tracks1.ItemIndex > 0) And 
      	                (TMSF2Second(aPos) = TMSF2Second(TrackPosition[MCI_TMSF_Track(aPos)])) then 
                        Tracks1.ItemIndex := Tracks1.ItemIndex - 1;
                     ChangeTrack(Mode = mpPlaying);
                  end;
         btStep : begin
                     aPos := Position;
                     aTrack := MCI_TMSF_TRACK(aPos);
                     aTime := TMSF2Second(aPos) + StepWidth;
                      
                     if aTime > TMSF2Second(EndPosition(aTrack)) then
                     begin
                        if Tracks1.ItemIndex < NumPlay-1 then
                           Tracks1.ItemIndex := Tracks1.ItemIndex + 1
                        else Tracks1.ItemIndex := 0;
                        ChangeTrack(Mode = mpPlaying);
                     end
                     else
                     begin
                        StartPos := MCI_MAKE_TMSF(aTrack,aTime div 60,aTime mod 60,0); 
                        EndPos := EndPosition(aTrack);
                        if (Mode = mpPlaying) then Play
                           else Position := StartPos;
                     end;
                  end;
         btBack : begin
                     aPos := Position;
                     aTrack := MCI_TMSF_TRACK(aPos);
                     aTime := TMSF2Second(aPos) - StepWidth;
                     
                     if aTime < TMSF2Second(StartPosition(aTrack)) then
                     begin
                        if Tracks1.ItemIndex > 0 then
                        begin
                           Tracks1.ItemIndex := Tracks1.ItemIndex - 1;
                           aTrack := StartPosition(PlayList^[Tracks1.ItemIndex].Track);
                           aTime := TMSF2Second(EndPosition(aTrack)) - StepWidth; 
                        end
                        else aTime := 0;
                     end;
                     StartPos := MCI_MAKE_TMSF(aTrack,aTime div 60,aTime mod 60,0); 
                     EndPos := EndPosition(aTrack);
                     if (Mode = mpPlaying) then Play
                     else Position := StartPos;
                  end;
         btEject: EjectClose;
      end;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.TimeModeChanged(Sender: TObject);
begin
     SpeedButton2.Down := False;
     SpeedButton3.Down := False;
     SpeedButton4.Down := False;
     TimeMenu1.Checked := False;
     TimeMenu2.Checked := False;
     TimeMenu3.Checked := False;

     if (Sender = SpeedButton2) OR (Sender = TimeMenu1) then
     begin
          TimeMode := tmTrackElapsed;
          SpeedButton2.Down := True;
          TimeMenu1.Checked := True;
     end
     else if (Sender = SpeedButton3) OR (Sender = TimeMenu2) then
     begin
          TimeMode := tmTrackRemaining;
          SpeedButton3.Down := True;
          TimeMenu2.Checked := True;
     end
     else if (Sender = SpeedButton4) OR (Sender = TimeMenu3) then
     begin
          TimeMode := tmDiscRemaining;
          SpeedButton4.Down := True;
          TimeMenu3.Checked := True;
     end;
     if UpdateDisplay then DrawTime(CalcTime);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.Display1Click(Sender: TObject);
begin
     if TimeMenu1.Checked then TimeModeChanged(TimeMenu2)
     else if TimeMenu2.Checked then TimeModeChanged(TimeMenu3)
          else if TimeMenu3.Checked then TimeModeChanged(TimeMenu1);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.RandomChanged(Sender: TObject);
begin
     RandomPlay := Not RandomPlay;
     SpeedButton5.Down := RandomPlay;
     RandomMenu.Checked := RandomPlay;
     if MediaPlayer1.DeviceID <> 0 then SetupPlayList;
     if UpdateDisplay then DrawTime(CalcTime);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ContinuousChanged(Sender: TObject);
begin
     ContinuousPlay := Not ContinuousPlay;
     SpeedButton6.Down := ContinuousPlay;
     ContinuousMenu.Checked := ContinuousPlay;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.IntroChanged(Sender: TObject);
begin
     IntroPlay := Not IntroPlay;
     SpeedButton7.Down := IntroPlay;
     IntroMenu.Checked := IntroPlay;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveIn1Stop(Sender: TObject);
begin
     MMWaveIn1.Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ToolBarMenuClick(Sender: TObject);
begin
     if ToolBar1.Visible then
     begin
          ToolBarMenu.Checked := False;
          ToolBar1.Visible := False;
          Bevel1.Visible := False;
          MinMaxHeight := Height - (ToolBar1.Height+Bevel1.Height);
          Height := MinMaxHeight;
      end
     else
     begin
          ToolBarMenu.Checked := True;
          ToolBar1.Top := -1;
          ToolBar1.Visible := True;
          Bevel1.Visible := True;
          MinMaxHeight := Height + (ToolBar1.Height+Bevel1.Height);
          Height := MinMaxHeight;
      end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DiscInfoMenuClick(Sender: TObject);
begin
     if DiscInfo1.Visible then
     begin
          DiscInfoMenu.Checked := False;
          MinMaxHeight := Height - (DiscInfo1.Height);
          Height := MinMaxHeight;
          DiscInfo1.Visible := False;
     end
     else
     begin
          DiscInfoMenu.Checked := True;
          MinMaxHeight := Height + (DiscInfo1.Height);
          Height := MinMaxHeight;
          DiscInfo1.Visible := True;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.PreferencesMenuClick(Sender: TObject);
begin
     with TPreferences.Create(Self) do
     try
        cbExitPlay.Checked := StopOnExit;
        cbToolTips.Checked := MainForm.ShowHint;
        if ShowModal = mrOK then
        begin
             StopOnExit := cbExitPlay.Checked;
             MainForm.ShowHint := cbToolTips.Checked;
        end;
     finally
        free;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.PlayListMenuClick(Sender: TObject);
Var
   i: integer;

begin
   with TPlaySettings.Create(Self) do
   try
      with MMCDInfo1 do
      begin
        edArtist1.Text := Artist;
        edTitle1.Text := Title;
        lbTrackList1.Items := Tracks;
        for i := 0 to NumPlay-1 do
            lbPlayList1.Items.Add(Tracks.Strings[PlayOrder[i]]);

        if ShowModal = mrOK then
        begin
             Artist := edArtist1.Text;
             Title := edTitle1.Text;
             Tracks := lbTrackList1.Items;
             NumPlay := lbPlayList1.Items.Count;
             for i := 0 to NumPlay-1 do
                 PlayOrder[i] := Tracks.IndexOf(lbPlayList1.Items[i]);

             SaveInfo;

             PlayListChanged;
        end;
      end;

   finally
      free;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.AboutMenuClick(Sender: TObject);
begin
     Show_AboutBox(0);
end;

end.
